'''
 by DR construction.
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'''
import inkex, simplestyle, simplepath, math
from simpletransform import *
from fractions import Fraction

class DimLine(inkex.Effect):

    def __init__(self):
        inkex.Effect.__init__(self)
        self.OptionParser.add_option("--scale",
                        action="store", type="string", 
                        dest="scale", default="pc",
                        help="i need it")
        self.OptionParser.add_option("-d", "--extrudeL",
                        action="store", type="string",
                        dest="extrudeL", default="50",
                        help="i need it")
        self.OptionParser.add_option("--type",
                        action="store", type="string", 
                        dest="type", default="Orthogonal",
                        help="i need it")
        self.OptionParser.add_option( "--fontsize",
                        action="store", type="int",
                        dest="fontsize", default="9",
                        help="i need it")
        self.OptionParser.add_option("--extrudeD",
                        action="store", type="string", 
                        dest="extrudeD", default="down",
                        help="i need it")
        self.OptionParser.add_option("--tab",
                        action="store", type="string", 
                        dest="tab", default="Notebook",
                        help="Notebook") 
        self.OptionParser.add_option("--lineWidth",
                        action="store", type="float", 
                        dest="lineWidth", default="0.5",
                        help="i need it")
        self.OptionParser.add_option("--tickWidth",
                        action="store", type="float", 
                        dest="tickWidth", default="1.5",
                        help="i need it")

        self.OptionParser.add_option("--manual",
                        action="store", type="string", 
                        dest="manual", default="false",
                        help="i need it")

        self.OptionParser.add_option("--fonttype",
                        action="store", type="string", 
                        dest="fonttype", default="normal",
                        help="i need it")
        self.OptionParser.add_option("--offset2",
                        action="store", type="float", 
                        dest="offset2", default="3",
                        help="i need it")


    def effect(self):

        for id, node in self.selected.iteritems():
            if node.tag == inkex.addNS('path','svg'):
                self.group = inkex.etree.SubElement( node.getparent(), inkex.addNS('g','svg') )
                self.lineGroup = inkex.etree.SubElement( self.group, inkex.addNS('g','svg') )
                self.numGroup = inkex.etree.SubElement( self.group, inkex.addNS('g','svg') )

                style = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.lineWidth * self.unittouu('1px'),'fill': 'none' })
                style2 = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.tickWidth * self.unittouu('1px'),'stroke-linecap':'round','fill': 'none' })
                style3 = simplestyle.formatStyle({ 'stroke': '#000', 'stroke-width':self.options.lineWidth * (self.unittouu('1px')*1.1),'fill': 'none' })
				#vars
                Li = ((self.options.lineWidth + self.options.tickWidth)*self.unittouu('1px')) + self.unittouu('5px')
                if self.options.manual == 'true'and self.options.extrudeD != 'angle' and self.options.extrudeD != 'textOnly':
                    man = -1
                    exl = 0
                else: 
                    man = 0
                    exl = int(self.options.extrudeL) * self.unittouu('1px')
                os = self.options.offset2 * self.unittouu('1px')
                p = simplepath.parsePath(node.get('d'))
                count = 0

                for cmd,params in p:	
                    count += 1
                    if cmd == 'Z' or cmd == 'z':
                        out_msg = "\t Closed paths do not work in this extension.\n\t Try - A line  "
                        inkex.errormsg(out_msg)
                        return
	    #non-looped atts
                x1set= p[0][1][-2]
                y1set= p[0][1][-1]
                y2set = p[-1][1][-1]
                x2set = p[-1][1][-2]
			#bbox cords
                if self.options.type == "step" or self.options.manual == 'true': 
                    self.bbox = computeBBox(self.selected.values()) 
                    xbbox = self.bbox[0]
                    ybbox = self.bbox[2]
                    y2bbox = self.bbox[3]
                    x2bbox = self.bbox[1]
                    if len(self.options.ids) != 1:
                        out_msg = "\t You've selected more than one object \n\t Try - selecting one line  "
                        inkex.errormsg(out_msg)
                        return
                else:
                    xbbox = x1set
                    ybbox = y1set
                    y2bbox = y1set
                    x2bbox = x1set
                if self.options.extrudeD == "right" and y1set == y2set or self.options.extrudeD == "left" and y1set == y2set:
                    out_msg = "\t Horizontal paths do not work in \n\t Offset direction. - left or right.\n\t Try Offset direction - up or down."
                    inkex.errormsg(out_msg)
                    return
                if self.options.extrudeD == "down" and x1set == x2set or self.options.extrudeD == "up" and x1set == x2set:
                    out_msg = "\t Vertical paths do not work in \n\t Offset direction. - up or down.\n\t Try Offset direction - left or right."
                    inkex.errormsg(out_msg)
                    return
                if self.options.extrudeD == "angle":
                           
                    boo = (math.sqrt(((x2set - x1set) ** 2) + ((y2set - y1set) ** 2)))
                    xfact =((x2set - x1set) / boo)
                    yfact =((y2set -y1set) / boo)
					#text x,y, degree
                    if x2set - x1set == 0: 
                        deg = -90							
                    else : deg = math.degrees(math.atan((y2set-y1set)/(x2set-x1set)))
                    if x2set - x1set < 0: 
                        ab = -((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                    if x1set - x2set < 0 :
                         ab= ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                    if x2set - x1set == 0: 
                        ab = -((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                    if x1set - x2set == 0 and y1set > y2set: 
                        ab = ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                    #Text offset						
                    xtp = (x1set+((x2set - x1set)/2 ))+((exl+ab)*yfact)
                    ytp = (y1set+((y2set - y1set)/2 ))-((exl+ab)*xfact)

                    #extrude line	
                    lineA_att = {
                      'style': style,
                      'd' : 'M '+str(x1set +(os * yfact ))+','+str(y1set - (os * xfact ))+' L '+str(x1set+((Li+exl)*yfact))+','+str(y1set-((Li+exl)*xfact))
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA_att )
                    #extrude line 2	
                    lineA1_att = {
                      'style': style,
                      'd' : 'M '+str(x2set+(os * yfact ))+','+str(y2set - (os * xfact ))+' L '+str(x2set+((Li+exl)*yfact))+','+str(y2set-((Li+exl)*xfact))
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA1_att )
					#measurement line
                    lineA2_att = {
                      'style': style3,
                      'd' : 'M '+str((x1set-Li *xfact) + (exl*yfact))+','+str((y1set-Li*yfact) - (exl*xfact) )+' L '+str((x2set+Li*xfact) + (exl*yfact))+','+str((y2set+Li*yfact) - (exl*xfact) )
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA2_att )
			        #tick
                    lineA3_att = {
                      'style': style2,
                      'd' : 'M '+str(x1set + ((exl-(Li/1.8))*yfact)-(Li/1.8)*xfact)+','+str(y1set - ((exl-(Li/1.8))*xfact)-(Li/1.8)*yfact) +' L '+str(x1set + ((exl+(Li/1.8))*yfact)+(Li/1.8)*xfact)+','+str(y1set - ((exl+(Li/1.8))*xfact)+(Li/1.8)*yfact)
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA3_att )
					#tick 2
                    lineA4_att = {
                      'style': style2,
                      'd' : 'M '+str(x2set + ((exl-(Li/1.8))*yfact)-(Li/1.8)*xfact)+','+str(y2set - ((exl-(Li/1.8))*xfact)-(Li/1.8)*yfact) +' L '+str(x2set + ((exl+(Li/1.8))*yfact)+(Li/1.8)*xfact)+','+str(y2set - ((exl+(Li/1.8))*xfact)+(Li/1.8)*yfact)
                    }
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),lineA4_att )

						

                if self.options.extrudeD != "angle" and self.options.extrudeD != "textOnly" :
                    if x1set < x2set : Lix = Li
                    if x1set > x2set : Lix = -Li
                    if y1set < y2set : Liy = Li
                    if y1set > y2set : Liy = -Li
                    if self.options.manual == 'true':
					   x2set= p[-2][1][-2]
					   y2set= p[-2][1][-1]	
					#measurement line
                    if self.options.extrudeD == "up":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set-Lix)+','+str((ybbox - exl) )+' L '+str(x2set+Lix)+','+str((ybbox - exl) )
                        }
                    if self.options.extrudeD == "down":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x1set-Lix)+','+str((y2bbox + exl) )+' L '+str(x2set+Lix)+','+str((y2bbox + exl) )
                        }
                    if self.options.extrudeD == "left":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(xbbox - exl)+','+str(y1set-Liy)+' L '+str(xbbox - exl)+','+str(y2set+Liy)
                        }
                    if self.options.extrudeD == "right":
                        line21_att = {
                          'style': style3,
                          'd' : 'M '+str(x2bbox + exl)+','+str(y1set-Liy)+' L '+str(x2bbox + exl)+','+str(y2set+Liy) 
                        }
						
                    inkex.etree.SubElement(self.lineGroup,inkex.addNS('path','svg'),line21_att )
        #looped atts	
					
                    num = 0
                    for i in range (count+man):
                        x1 = p[num][1][-2]
                        y1 = p[num][1][-1]
                        num += 1

                        if self.options.type == "Orthogonal":
                            y1flex = y1set
                            x1flex = x1set
                        if self.options.type == "step": 
                            y1flex = y1
                            x1flex = x1

                        if self.options.extrudeD == "up":
                             #extrude line				
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1)+','+str(y1flex - os )+' L '+str(x1)+','+str((ybbox - exl) - (Li))
                            }							
          
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str(x1 - (Li/1.8))+','+str((ybbox - exl) + (Li/1.8))+' L '+str(x1 + (Li/1.8))+','+str((ybbox - exl) - (Li/1.8))
                            }
                        if self.options.extrudeD == "down":
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1)+','+str(y1flex + os)+' L '+str(x1)+','+str((y2bbox + exl) + (Li))
                            }
			
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str(x1 - (Li/1.8))+','+str((y2bbox + exl) + (Li/1.8))+' L '+str(x1 + (Li/1.8))+','+str((y2bbox + exl) - (Li/1.8))
                            }
                        if self.options.extrudeD == "left":
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1flex - os )+','+str(y1)+' L '+str((xbbox - exl)- Li)+','+str(y1)
                            }
			
							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str((xbbox - exl) + (Li/1.8))+','+str(y1 + (Li/1.8))+' L '+str(xbbox - exl - (Li/1.8))+','+str(y1 - (Li/1.8))
                            }
                        if self.options.extrudeD == "right":
                            #extrude line						
                            line_att = {
                              'style': style,
                              'd' : 'M '+str(x1flex + os )+','+str(y1)+' L '+str((x2bbox + exl)+ Li)+','+str(y1)
                            }
 							#tick
                            line3_att = {
                              'style': style2,
                              'd' : 'M '+str((x2bbox + exl) + (Li/1.8))+','+str(y1 + (Li/1.8))+' L '+str(x2bbox + exl - (Li/1.8))+','+str(y1 - (Li/1.8))
                            }
						 
                        inkex.etree.SubElement(
                          self.lineGroup,
                          inkex.addNS('path','svg'),
                          line_att )						
          
                        inkex.etree.SubElement(
                          self.lineGroup,
                          inkex.addNS('path','svg'),
                          line3_att )

				#Text
                num = 0
                for i in range (count-1+man):
                    x1L = p[num][1][-2]
                    y1L = p[num][1][-1]
                    y2L = p[num+1][1][-1]
                    x2L = p[num+1][1][-2]
                    num += 1
                    if self.options.extrudeD == "up" or self.options.extrudeD == "down":
                        boo = (x2L - x1L)						
                    if self.options.extrudeD == "left" or self.options.extrudeD == "right":
                        boo = (y1L - y2L)

                    if self.options.extrudeD == "up":#text x,y, degree
                        xtp = x1L + ( boo/2 )
                        ytp = ybbox - exl - ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                        deg = 0	
                    if self.options.extrudeD == "down":#text x,y, degree
                        xtp = x1L + ( boo/2 )
                        ytp = y2bbox + exl - ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                        deg = 0	
                    if self.options.extrudeD == "left":#text x,y, degree
                        xtp = xbbox - exl - ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                        ytp = y1L - ( boo/2 )
                        deg = -90
                    if self.options.extrudeD == "right":#text x,y, degree
                        xtp = x2bbox + exl - ((self.options.lineWidth/2)+2+(self.options.fontsize/4))*self.unittouu('1px')
                        ytp = y1L - ( boo/2 )
                        deg = -90
                    if self.options.extrudeD == "textOnly":#text x,y, degree
                        boo = (math.sqrt(((x2L - x1L) ** 2) + ((y2L - y1L) ** 2)))
                        xfact =((x2L - x1L) / boo)
                        yfact =((y2L -y1L) / boo)
					    #text x,y, degree
                        if x2L - x1L == 0: 
                            deg = -90						
                        else : deg = math.degrees(math.atan((y2L-y1L)/(x2L-x1L)))
                        if x2L <= x1L :
                            xab = (os+(self.options.fontsize* self.unittouu('1px') ))*xfact
                            yab = (os+(self.options.fontsize* self.unittouu('1px') ))*yfact
                        else: 
                            xab = os*xfact
                            yab = os*yfact								
                        if deg == -90 and y1L > y2L:
                            xab = 0
                            yab = - os				
                        xtp = ((x1L+((x2L - x1L)/2 ))+ yab)   
                        ytp = ((y1L+((y2L - y1L)/2 ))- xab) 				
 					
						
                    scale = float(self.options.scale) * self.unittouu('1px')
                    meter = abs(boo / scale) 
                    cm = (meter%1) * 100

                    if meter >= 1:
                        leng = str(int(meter)) + " , " + str(int(cm))
                    if meter < 1:
                        leng =  str(round(cm,0))
			
                    t='rotate(%f,%f,%f) matrix(1,0,0,1,0,-%f)' % (deg,xtp,ytp,0)
 					
                    self.addText(
                        self.numGroup,
                        xtp,
                        ytp,
                        leng, transform = t )				
                node.getparent().remove (node)

    def addText(self,node,x,y,text, transform=None):
                fonttype = self.options.fonttype.split(",")
                if len(fonttype) < 2  : 
                    fonttype1 = self.options.fonttype
                    fonttype2 = 0
                else : 
                    fonttype1 = fonttype[0]
                    fonttype2 = fonttype[1]
                new = inkex.etree.SubElement(node,inkex.addNS('text','svg'))
                s = {'text-align': 'center', 'vertical-align': 'top','text-anchor': 'middle',
				    'font-size': int(self.options.fontsize)* self.unittouu('1pt') , 'fill-opacity': '1.0', 'stroke': 'none',
                    'font-weight': str(fonttype2),'font-family': str(fonttype1)}
                new.set('style', simplestyle.formatStyle(s))
                if not transform==None:
                  new.set('transform', str(transform))
                new.set('x', str(x))
                new.set('y', str(y))
                new.text = str(text)
            
if __name__ == '__main__':
    e = DimLine()
    e.affect()


# vim: expandtab shiftwidth=4 tabstop=8 softtabstop=4 encoding=utf-8 textwidth=99
